% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBContour.R
\name{MBContour}
\alias{MBContour}
\title{Computes Multiplier Bootstrap realizations of the supremum of a Gaussian 
field on a contour.}
\usage{
MBContour(x, y, R, cont, N = 1000)
}
\arguments{
\item{x}{x-Coordinates of the grid on which the data is observed.}

\item{y}{y-Coordinates of the grid on which the data is observed.}

\item{R}{An array of dimension c(length(x),length(y),n) containing the 
realizations of the field.}

\item{cont}{The contours of f at value level}

\item{N}{The number of Bootstrap realizations to produce. Default is 1000.}
}
\value{
A vector of length N containing the Bootstrap realizations of the 
        supremum.
}
\description{
Computes Multiplier Bootstrap realizations of the supremum of a Gaussian 
field on a contour.
}
