% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RobustDecomp.R
\name{RobustDecomp}
\alias{RobustDecomp}
\title{Robust decomposition}
\usage{
RobustDecomp(v, method = "f")
}
\arguments{
\item{v}{A square numerical matrix.}

\item{method}{The decomposition method.  Valid choices are
\code{"fast"} (try cholesky, then eigen, then singular value decomposition),
\code{"chol"} (cholesky), \code{"eigen"} (eigen), and 
\code{"svd"} (singular value decomposition).}
}
\value{
A matrix
}
\description{
Given a covariance matrix \code{v}, the function computes
a decomposition of \code{v} in a robust way.  If the
decomposition is \code{dvi}, then \code{dvi \%*\% v \%*\% t(dvi)}
should be the identity matrix.
}
\examples{
# generate positive definite matrix
v <- crossprod(matrix(rnorm(25), nrow = 5))

# check cholesky
dvic <- RobustDecomp(v, method = "c")
all.equal(dvic \%*\% v \%*\% t(dvic), diag(5))

# check eigen
dvie <- RobustDecomp(v, method = "e")
all.equal(dvie \%*\% v \%*\% t(dvie), diag(5))

# check svd
dvis <- RobustDecomp(v, method = "s")
all.equal(dvis \%*\% v \%*\% t(dvis), diag(5))
}
