% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeCope.R
\name{plot.cope}
\alias{plot.cope}
\title{Plots CoPE sets.}
\usage{
\method{plot}{cope}(x, ..., taylor = FALSE, use.true.function = FALSE,
  colc = "purple", lwdc = 3, ltyc = 1, colp = "darkred", lwdp = 3,
  ltyp = 1, colm = "darkgreen", lwdm = 3, ltym = 1,
  conlist = list(drawlabels = FALSE))
}
\arguments{
\item{x}{An object of class cope to be plotted.}

\item{...}{Additional graphical parameters passed to fields::image.plot.}

\item{taylor}{Boolean indicating whether the CoPE sets with the threshold 
obtained by Taylor's method should be plotted. Default is
FALSE.}

\item{use.true.function}{Boolean indicating whether the threshold obtained 
from the true function should be used. Default is 
FALSE.}

\item{colc}{Color of contour line for \eqn{A_c}.}

\item{lwdc}{Width of contour line for \eqn{A_c}.}

\item{ltyc}{Type of contour line for \eqn{A_c}.}

\item{colp}{Color of contour line for \eqn{\hat{A}^{+}_c}.}

\item{lwdp}{Width of contour line for \eqn{\hat{A}^{+}_c}.}

\item{ltyp}{Type of contour line for \eqn{\hat{A}^{+}_c}.}

\item{colm}{Color of contour line for \eqn{\hat{A}^{-}_c}.}

\item{lwdm}{Width of contour line for \eqn{\hat{A}^{-}_c}.}

\item{ltym}{Type of contour line for \eqn{\hat{A}^{-}_c}.}

\item{conlist}{A list of additional arguments to pass to the \code{contour} function.
By default, the contour labels are not shown.}
}
\description{
Plots CoPE sets.
}
\examples{
# An example using the ToyNoise and ToySignal of this package.
\dontrun{
n = 30
Data = ToyNoise1(n = n)
Data$z = Data$z + rep(ToySignal()$z, n)
CopeSet = ComputeCope(Data, level=4/3, mu=ToySignal()$z)
plot(CopeSet)}
}
\references{
M. Sommerfeld, S. Sain and A. Schwartzman. Confidence regions for 
            excursion sets in asymptotically Gaussian
            random fields, with an application to climate. Preprint, 2015.
}
