wd = "~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis"
setwd(wd)
# load relevant data
load("tmax_summer.rda")
load("tmax_summer_covar.rda")
# load auxiliary functions
source("aux_funcs.R")

# determine which grid locations not NA
idx = which(!is.na(mask), arr.ind = TRUE)

# formulas for model classes
f_apl = temp ~ yr + rcm + gcm
f_ipl = temp ~ yr + rcm + gcm + rcm:gcm
f_asl = temp ~ rcm + gcm + yr + yr:rcm + yr:gcm
f_isl = temp ~ rcm*gcm + yr*(rcm*gcm)

# lists to store fitted models
lmod_apl = lmod_apl1 = lmod_apl2 = lmod_ipl1 = lmod_ipl2 = lmod_asl = lmod_asl1 = lmod_asl2 = lmod_isl1 = lmod_isl2 = vector("list", nrow(idx))

# reorder data, obtain mini-experiment indices
tempdf = data.frame(rcm, gcm, yr)
tempdf$gr = paste(tempdf$gcm, tempdf$rcm, sep = "_")
ogr = order(tempdf$gr)
tempdf = tempdf[ogr, ]
set1 = which(is.element(tempdf$gcm, c("cgcm3", "ccsm")) & is.element(tempdf$rcm, c("crcm", "wrfg")))
set2 = which(is.element(tempdf$gcm, c("gfdl", "hadcm3")) & is.element(tempdf$rcm, c("ecp2", "hrm3")))

# double-check sets obtained correctly
tempdf1 = tempdf[set1,]
tempdf1$rcm = droplevels(tempdf1$rcm)
tempdf1$gcm = droplevels(tempdf1$gcm)
tempdf2 = tempdf[set2,]
tempdf2$rcm = droplevels(tempdf2$rcm)
tempdf2$gcm = droplevels(tempdf2$gcm)
table(tempdf2$rcm, tempdf2$gcm)
table(tempdf2$rcm, tempdf2$gcm)

p_apl = c(2, 0, 1, 0, 1, 0, 2, 0, 0, 0, 1, 1)
p_apl1 = c(2, 1, 0, 0)
p_apl2 = c(2, 0, 0, 1)
p_ipl1 = c(2, 1, 0, 0)
p_ipl2 = c(2, 0, 0, 1)
p_asl = c(2, 0, 1, 0, 1, 0, 4, 1, 0, 1, 1, 1)
p_asl1 = c(2, 1, 0, 0)
p_asl2 = c(4, 1, 1, 1)
p_isl1 = c(2, 1, 0, 0)
p_isl2 = c(2, 1, 1, 1)

save(idx = idx, set1 = set1, set2 = set2, ogr = ogr,
     p_apl = p_apl, p_apl1 = p_apl1, p_apl2 = p_apl2,
     p_ipl1 = p_ipl1, p_ipl2 = p_ipl2,
     p_asl = p_asl, p_asl1 = p_asl1, p_asl2 = p_asl2,
     p_isl1 = p_isl1, p_isl2 = p_isl2, 
     file = "fit_details.rda")

for (i in seq_along(idx[,1])) {
  tempdata = data.frame(temp = tmax[idx[i, 1], idx[i, 2], ], rcm, gcm, yr)
  tempdata$gr = paste(tempdata$gcm, tempdata$rcm, sep = ":")
  tempdata = tempdata[ogr, ]
  tempdata1 = tempdata[set1, ]
  tempdata1$gcm = droplevels(tempdata1$gcm)
  tempdata1$rcm = droplevels(tempdata1$rcm)
  tempdata2 = tempdata[set2, ]
  tempdata2$gcm = droplevels(tempdata2$gcm)
  tempdata2$rcm = droplevels(tempdata2$rcm)
  
  lmod_apl[[i]] = gls_fit(f_apl, tempdata, p = p_apl)
  lmod_apl1[[i]]  = gls_fit(f_apl, tempdata1, p = p_apl1)
  lmod_apl2[[i]]  = gls_fit(f_apl, tempdata2, p = p_apl2)
  lmod_ipl1[[i]] = gls_fit(f_ipl, tempdata1, p = p_ipl1)
  lmod_ipl2[[i]] = gls_fit(f_ipl, tempdata2, p = p_ipl2)
  lmod_asl[[i]] = gls_fit(f_asl, tempdata, p = p_asl)
  lmod_asl1[[i]] = gls_fit(f_asl, tempdata1, p = p_asl1)
  lmod_asl2[[i]] = gls_fit(f_asl, tempdata2, p = p_asl2)
  lmod_isl1[[i]] = gls_fit(f_isl, tempdata1, p = p_isl1)
  lmod_isl2[[i]] = gls_fit(f_isl, tempdata2, p = p_isl2)

  if ((i %% 100) == 0) cat(paste(i, ""))
}

save(lmod_apl, lmod_apl1, lmod_apl2,
     lmod_ipl1, lmod_ipl2,
     lmod_asl, lmod_asl1, lmod_asl2,
     lmod_isl1, lmod_isl2, 
     file = "cope_diagnostics_bias2_glsmods.rda", 
     compress = "bzip2")