library(autoimage)

setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
# load relevant data
load("tmax_summer_covar.rda")
load(file = "cope_diagnostics_bias2_glsmods.rda")
load("fit_details.rda")

# convert list 2 array for plotting
list2array = function(x){
  out = array(NA, dim = c(length(lon), length(lat), length(x[[1]]$coef)))
  for (i in seq_along(x)) {
    out[idx[i,1], idx[i,2],] = x[[i]]$coef
  }
  out
}

# asl_coef = list2array(lmod_asl)
# autoimage(lon, lat, asl_coef[,,1:9], axes = FALSE, 
#           xlab = "", ylab = "", legend = "n", 
#           common.legend = FALSE)
# autoimage(lon, lat, asl_coef[,,10:18], axes = FALSE, 
#           xlab = "", ylab = "", legend = "n", 
#           common.legend = FALSE)
# 
asl1_coef = list2array(lmod_asl1)
# autoimage(lon, lat, asl1_coef, size = c(3, 2), axes = FALSE, 
#           xlab = "", ylab = "", 
#           legend = "n", common.legend = FALSE)

cmap <- hcl(h = 240, c = 50, l = seq(10, 99, len = 64))

ti <- c(expression(mu),
        expression(alpha),
        expression(beta),
        expression(gamma),
        expression(zeta),
        expression(eta)
        )

pdf("fig02_continuity_asl1_coef.pdf", height = 5, width = 5)
par(mar = c(1.1, 1.1, 1.1, 1.1))
autoimage(lon, lat, asl1_coef, size = c(3, 2), main = ti,
          axes = FALSE, xlab = "", ylab = "", 
          common.legend = FALSE,
          col = cmap, lrat = 0.5, proj = "lambert",
          parameters = c(33, 45))
reset.par()
dev.off()

# par(mar = c(0.1, 0.1, 0.1, 0.1))
# 
# asl2_coef = list2array(lmod_asl2)
# autoimage(lon, lat, asl2_coef, axes = FALSE, xlab = "", 
#           ylab = "", legend = "n", common.legend = FALSE)
# 
# isl1_coef = list2array(lmod_isl1)
# autoimage(lon, lat, isl1_coef, size = c(4, 2), axes = FALSE, 
#           xlab = "", ylab = "", legend = "n", 
#           common.legend = FALSE)
# 
# isl2_coef = list2array(lmod_isl2)
# autoimage(lon, lat, isl2_coef, size = c(4, 2), axes = FALSE,
#           xlab = "", ylab = "", legend = "n", 
#           common.legend = FALSE)
#           