setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
# load relevant data
load("tmax_summer_covar.rda")
load(file = "cope_diagnostics_bias2_glsmods.rda")
load("fit_details.rda")

get_res = function(x, samp){
  sapply(samp, function(q) x[[q]]$sresiduals)
}

# select random locations
set.seed(27)
rand_apl = sample(seq_len(length(lmod_apl)), 9)
rand_apl1 = sample(seq_len(length(lmod_apl1)), 9)
rand_apl2 = sample(seq_len(length(lmod_apl2)), 9)
rand_ipl1 = sample(seq_len(length(lmod_ipl1)), 9)
rand_ipl2 = sample(seq_len(length(lmod_ipl2)), 9)
rand_asl = sample(seq_len(length(lmod_asl)), 9)
rand_asl1 = sample(seq_len(length(lmod_asl1)), 9)
rand_asl2 = sample(seq_len(length(lmod_asl2)), 9)
rand_isl1 = sample(seq_len(length(lmod_isl1)), 9)
rand_isl2 = sample(seq_len(length(lmod_isl2)), 9)

# get standardized residuals from randomly selected locations
sres_apl = get_res(lmod_apl, rand_apl)
sres_apl1 = get_res(lmod_apl1, rand_apl1)
sres_apl2 = get_res(lmod_apl2, rand_apl2)
sres_ipl1 = get_res(lmod_ipl1, rand_ipl1)
sres_ipl2 = get_res(lmod_ipl2, rand_ipl2)
sres_asl = get_res(lmod_asl, rand_asl)
sres_asl1 = get_res(lmod_asl1, rand_asl1)
sres_asl2 = get_res(lmod_asl2, rand_asl2)
sres_isl1 = get_res(lmod_isl1, rand_isl1)
sres_isl2 = get_res(lmod_isl2, rand_isl2)

# estimated density from each model
dapl = apply(sres_apl, 2, density)
dapl1 = apply(sres_apl1, 2, density)
dapl2 = apply(sres_apl2, 2, density)
dipl1 = apply(sres_ipl1, 2, density)
dipl2 = apply(sres_ipl2, 2, density)
dasl = apply(sres_asl, 2, density)
dasl1 = apply(sres_asl1, 2, density)
dasl2 = apply(sres_asl2, 2, density)
disl1 = apply(sres_isl1, 2, density)
disl2 = apply(sres_isl2, 2, density)

# create function to plot list of densities
plot_list = function(x, main = "", xlab = ""){
  maxy = sapply(x, function(j) j$y)
  plot(x[[1]], ylim = range(maxy), xlab = xlab, main = main, xlim = c(-3,3))
  for (j in seq_along(x)) {
    lines(x[[j]], col = j)
  }
}

pdf("fig03_model_densities.pdf", height = 3, width = 8)
par(mfrow = c(2, 5), mar = c(2.1, 4.1, 4.1, 2.1))
plot_list(dapl, main = "(a) APL")
plot_list(dapl1, main = "(b) APL1")
plot_list(dapl2, main = "(c) APL2")
plot_list(dipl1, main = "(d) IPL1")
plot_list(dipl2, main = "(e) IPL2")
plot_list(dasl, main = "(f) ASL")
plot_list(dasl1, main = "(g) ASL1")
plot_list(dasl2, main = "(h) ASL2")
plot_list(disl1, main = "(i) ISL1")
plot_list(disl2, main = "(j) ISL2")
dev.off()


