library(ggthemes)

setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
# load relevant data
load("tmax_summer_covar.rda")
load(file = "cope_diagnostics_bias2_glsmods.rda")
source("aux_funcs.R") # for ljeung-box tests

# get p-values from ljeung-box tests
lbp_apl = lb_lmod(lmod_apl)
lbp_apl1 = lb_lmod(lmod_apl1)
lbp_apl2 = lb_lmod(lmod_apl2)
lbp_ipl1 = lb_lmod(lmod_ipl1)
lbp_ipl2 = lb_lmod(lmod_ipl2)
lbp_asl = lb_lmod(lmod_asl)
lbp_asl1 = lb_lmod(lmod_asl1)
lbp_asl2 = lb_lmod(lmod_asl2)
lbp_isl1 = lb_lmod(lmod_isl1)
lbp_isl2 = lb_lmod(lmod_isl2)

# compute estimated null proportions
(eta_apl = eta0(lbp_apl))
(eta_apl1 = eta0(lbp_apl1))
(eta_apl2 = eta0(lbp_apl2))
(eta_ipl1 = eta0(lbp_ipl1))
(eta_ipl2 = eta0(lbp_ipl2))
(eta_asl = eta0(lbp_asl))
(eta_asl1 = eta0(lbp_asl1))
(eta_asl2 = eta0(lbp_asl2))
(eta_isl1 = eta0(lbp_isl1))
(eta_isl2 = eta0(lbp_isl2))

# relabel eta values for sets1 and sets2 to match full data
eta_short_label = function(x) {
  names <- c("ccsm:crcm",   "ccsm:mm5i",   "ccsm:wrfg",   
             "cgcm3:crcm",  "cgcm3:rcm3",  "cgcm3:wrfg",
             "gfdl:ecp2",   "gfdl:hrm3",   "gfdl:rcm3",   
             "hadcm3:ecp2", "hadcm3:hrm3", "hadcm3:mm5i")
  xnames = names(x)
  out = rep(NA, length(names))
  for (i in seq_along(xnames)) {
    w = which(xnames[[i]] == names)
    out[w] = x[i]
  }
  out
}

eta_df = data.frame(APL = eta_apl,
                    APL1 = eta_short_label(eta_apl1),
                    APL2 = eta_short_label(eta_apl2),
                    IPL1 = eta_short_label(eta_ipl1),
                    IPL2 = eta_short_label(eta_ipl2),
                    ASL = eta_asl,
                    ASL1 = eta_short_label(eta_asl1),
                    ASL2 = eta_short_label(eta_asl2),
                    ISL1 = eta_short_label(eta_isl1),
                    ISL2 = eta_short_label(eta_isl2))
# library(xtable)
# xtable(eta_df)

cdf_apl = cdf(lbp_apl)
cdf_apl1 = cdf(lbp_apl1)
cdf_apl2 = cdf(lbp_apl2)
cdf_ipl1 = cdf(lbp_ipl1)
cdf_ipl2 = cdf(lbp_ipl2)
cdf_asl = cdf(lbp_asl)
cdf_asl1 = cdf(lbp_asl1)
cdf_asl2 = cdf(lbp_asl2)
cdf_isl1 = cdf(lbp_isl1)
cdf_isl2 = cdf(lbp_isl2)

# convert cdf output for function suitable for plotting
# with ggplot2
convert = function(x) {
  n = length(x)
  nr = length(x[[1]])
  nam = names(x)
  tsplit = strsplit(nam, ":")
  gcm = sapply(tsplit, getElement, 1)
  rcm = sapply(tsplit, getElement, 2)
  df = data.frame(ecdf = unlist(x), 
                  p = seq(0.01, 0.99, len = 99), 
                  gr = rep(nam, each = nr),
                  gcm = rep(gcm, each = nr),
                  rcm = rep(rcm, each = nr))
  df
}

# convert ecdfs to plotting format
apl_df = convert(cdf_apl)
apl1_df = convert(cdf_apl1)
apl2_df = convert(cdf_apl2)
ipl1_df = convert(cdf_ipl1)
ipl2_df = convert(cdf_ipl2)
asl_df = convert(cdf_asl)
asl1_df = convert(cdf_asl1)
asl2_df = convert(cdf_asl2)
isl1_df = convert(cdf_isl1)
isl2_df = convert(cdf_isl2)

# combine all data frames into one
all_df = rbind(cbind(apl_df, model = "APL"),
               cbind(apl1_df, model = "APL1"),
               cbind(apl2_df, model = "APL2"),
               cbind(ipl1_df, model = "IPL1"),
               cbind(ipl2_df, model = "IPL2"),
               cbind(asl_df, model = "ASL"),
               cbind(asl1_df, model = "ASL1"),
               cbind(asl2_df, model = "ASL2"),
               cbind(isl1_df, model = "ISL1"),
               cbind(isl2_df, model = "ISL2"))

pdf("fig04_ecdf_all.pdf", height = 9, width = 6)
ggplot(all_df, aes(x = p, y = ecdf)) + geom_line(aes(col = model)) + 
  geom_abline(aes(col = "darkgrey"), slope = 1) + theme_base() + 
  facet_grid(rcm ~ gcm) + xlab("probability") + ylab("empirical cdf") + 
  scale_x_continuous(breaks = c(0, 0.25, 0.5, 0.75, 1)) + 
  scale_y_continuous(breaks = c(0, 0.25, 0.5, 0.75, 1)) + 
  # scale_colour_brewer(type = "qual", palette = "Paired") + 
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5), 
        panel.spacing = unit(10, "points"), 
        legend.position = "bottom")
dev.off()