setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
# load relevant data
load("tmax_summer.rda")
load("tmax_summer_covar.rda")
load("v_asl.rda")
load("fit_details.rda")
# load relevant functions
source("aux_funcs.R")

f = formula(~ rcm + gcm + yr + yr:rcm + yr:gcm)

# only need design matrix for first 356 observations.
# other sequential blocks of 356 will have the exact same design matrix

# corner/treatment constraint
options(contrasts = rep("contr.treatment", 2))
df = data.frame(rcm, gcm, yr)[ogr, ]
X = model.matrix(f, data = df)
Z = list(x = lon, y = lat, z = tmax[,,ogr])

z8 = rep(0, 8)
# rcm12_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, -1, 0, 0, 0, 0, 0, 0, 0, z8))
# rcm13_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, -1, 0, 0, 0, 0, 0, 0, z8))
# rcm14_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, -1, 0, 0, 0, 0, 0, z8))
# rcm15_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, -1, 0, 0, 0, 0, z8))
# rcm16_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, -1, 0, 0, 0, z8))
# rcm23_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 1, -1, 0, 0, 0, 0, 0, 0, z8))
# rcm24_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 1, 0, -1, 0, 0, 0, 0, 0, z8))
# rcm25_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 1, 0, 0, -1, 0, 0, 0, 0, z8))
# rcm26_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 1, 0, 0, 0, -1, 0, 0, 0, z8))
# rcm34_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 1, -1, 0, 0, 0, 0, 0, z8))
# rcm35_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 1, 0, -1, 0, 0, 0, 0, z8))
# rcm36_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 1, 0, 0, -1, 0, 0, 0, z8))
# rcm45_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 1, -1, 0, 0, 0, 0, z8))
# rcm46_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 1, 0, -1, 0, 0, 0, z8))
# rcm56_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 1, -1, 0, 0, 0, z8))
# gcm12_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, -1, 0, 0, z8))
# gcm13_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, 0, -1, 0, z8))
# gcm14_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, 0, 0, -1, z8))
# gcm23_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, 1, -1, 0, z8))
# gcm24_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, 1, 0, -1, z8))
# gcm34_sl_std = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, 0, 1, -1, z8))
# 
# save(rcm12_sl_std, rcm13_sl_std, rcm14_sl_std, rcm15_sl_std, rcm16_sl_std, 
#      rcm23_sl_std, rcm24_sl_std, rcm25_sl_std, rcm26_sl_std, 
#      rcm34_sl_std, rcm35_sl_std, rcm36_sl_std,
#      rcm45_sl_std, rcm46_sl_std,
#      rcm56_sl_std,
#      gcm12_sl_std, gcm13_sl_std, gcm14_sl_std, 
#      gcm23_sl_std, gcm24_sl_std,
#      gcm34_sl_std, 
#      file = "cope_additive_sl_std_intercept.rda")

z9 = rep(0, 9)
rcm_crcm_ecp2_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, -1, 0, 0, 0, 0, 0, 0, 0), V = v_asl)
rcm_crcm_hrm3_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, -1, 0, 0, 0, 0, 0, 0), V = v_asl)
rcm_crcm_mm5i_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, -1, 0, 0, 0, 0, 0), V = v_asl)
rcm_crcm_rcm3_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, 0, -1, 0, 0, 0, 0), V = v_asl)
rcm_crcm_wrfg_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, 0, 0, -1, 0, 0, 0), V = v_asl)
rcm_ecp2_hrm3_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 1, -1, 0, 0, 0, 0, 0, 0), V = v_asl)
rcm_ecp2_mm5i_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 1, 0, -1, 0, 0, 0, 0, 0), V = v_asl)
rcm_ecp2_rcm3_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 1, 0, 0, -1, 0, 0, 0, 0), V = v_asl)
rcm_ecp2_wrfg_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 1, 0, 0, 0, -1, 0, 0, 0), V = v_asl)
rcm_hrm3_mm5i_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 1, -1, 0, 0, 0, 0, 0), V = v_asl)
rcm_hrm3_rcm3_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 1, 0, -1, 0, 0, 0, 0), V = v_asl)
rcm_hrm3_wrfg_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 1, 0, 0, -1, 0, 0, 0), V = v_asl)
rcm_mm5i_rcm3_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, 1, -1, 0, 0, 0, 0), V = v_asl)
rcm_mm5i_wrfg_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, 1, 0, -1, 0, 0, 0), V = v_asl)
rcm_rcm3_wrfg_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, 0, 1, -1, 0, 0, 0), V = v_asl)

z15 = rep(0, 15)
gcm_ccsm_cgcm3_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z15, -1, 0, 0), V = v_asl)
gcm_ccsm_gfdl_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z15, 0, -1, 0), V = v_asl)
gcm_ccsm_hadcm3_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z15, 0, 0, -1), V = v_asl)
gcm_cgcm3_gfdl_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z15, 1, -1, 0), V = v_asl)
gcm_cgcm3_hadcm3_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z15, 1, 0, -1), V = v_asl)
gcm_gfdl_hadcm3_sl_std = gls_lh(Z, level = 0, X = X, mask = mask, w = c(z15, 0, 1, -1), V = v_asl)

save(rcm_crcm_ecp2_sl_std, rcm_crcm_hrm3_sl_std,
     rcm_crcm_mm5i_sl_std, rcm_crcm_rcm3_sl_std,
     rcm_crcm_wrfg_sl_std, rcm_ecp2_hrm3_sl_std,
     rcm_ecp2_mm5i_sl_std, rcm_ecp2_rcm3_sl_std,
     rcm_ecp2_wrfg_sl_std,
     rcm_hrm3_mm5i_sl_std, rcm_hrm3_rcm3_sl_std,
     rcm_hrm3_wrfg_sl_std, rcm_mm5i_rcm3_sl_std,
     rcm_mm5i_wrfg_sl_std,
     rcm_rcm3_wrfg_sl_std,
     gcm_ccsm_cgcm3_sl_std,
     gcm_ccsm_gfdl_sl_std,
     gcm_ccsm_hadcm3_sl_std,
     gcm_cgcm3_gfdl_sl_std,
     gcm_cgcm3_hadcm3_sl_std,
     gcm_gfdl_hadcm3_sl_std,
     file = "std_asl_slope_bias.rda")
