setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
# load relevant data
load("tmax_summer.rda")
load("tmax_summer_covar.rda")
load("v_isl1.rda")
load("v_isl2.rda")
load("fit_details.rda")
# load relevant functions
source("aux_funcs.R")

f = formula(~ rcm*gcm + yr*(rcm*gcm))

# corner/treatment constraint
options(contrasts = rep("contr.treatment", 2))
df = data.frame(rcm, gcm, yr)[ogr, ]
df1 = df[set1,]
df1$rcm = droplevels(df1$rcm)
df1$gcm = droplevels(df1$gcm)
df2 = df[set2,]
df2$rcm = droplevels(df2$rcm)
df2$gcm = droplevels(df2$gcm)
table(df1$gcm, df1$rcm)
table(df2$gcm, df2$rcm)

X1 = model.matrix(f, data = df1)
X2 = model.matrix(f, data = df2)
otmax = tmax[,,ogr]
Z1 = list(x = lon, y = lat, z = otmax[,,set1])
Z2 = list(x = lon, y = lat, z = otmax[,,set2])

z3 = rep(0, 3)
z5 = rep(0, 5)

# first experiment
wrfg_sl_std = gls_lh(Z1, level = 0, X = X1, mask = mask, w = c(0, 1, 0, 0, 0, z3), V = v_isl1)
ccsm_sl_std = gls_lh(Z1, level = 0, X = X1, mask = mask, w = c(0, 0, 1, 0, 0, z3), V = v_isl1)
interact_wrfg_ccsm_sl_std = gls_lh(Z1, level = 0, X = X1, mask = mask, w = c(0, 0, 0, 0, 1, z3), V = v_isl1)
interact_wrfg_ccsm_slope_sl_std = gls_lh(Z1, level = 0, X = X1, mask = mask, w = c(z5, c(0, 0, 1)), V = v_isl1)

## second experiment
hrm3_sl_std = gls_lh(Z2, level = 0, X = X2, mask = mask, w = c(0, 0, 1, 0, 0, z3), V = v_isl2)
hadcm3_sl_std = gls_lh(Z2, level = 0, X = X2, mask = mask, w = c(0, 0, 0, 1, 0, z3), V = v_isl2)
interact_hrm3_hadcm3_sl_std = gls_lh(Z2, level = 0, X = X2, mask = mask, w = c(0, 0, 0, 0, 1, z3), V = v_isl2)
interact_hrm3_hadcm3_slope_sl_std = gls_lh(Z2, level = 0, X = X2, mask = mask, w = c(z5, c(0, 0, 1)), V = v_isl2)

save(interact_wrfg_ccsm_sl_std, wrfg_sl_std, ccsm_sl_std, 
     interact_wrfg_ccsm_slope_sl_std,
     interact_hrm3_hadcm3_sl_std, hrm3_sl_std, hadcm3_sl_std,
     interact_hrm3_hadcm3_slope_sl_std,
     file = "std_isl_bias.rda")