setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
# load relevant data
load("tmax_summer.rda")
load("tmax_summer_covar.rda")
load("v_apl.rda")
load("fit_details.rda")
# load relevant functions
library(cope)

f = formula(~ yr + rcm + gcm)

# only need design matrix for first 358 observations.
# other sequential blocks of 358 will have the exact same design matrix

# corner/treatment constraint
options(contrasts = rep("contr.treatment", 2))
df = data.frame(rcm, gcm, yr)[ogr, ]
X = model.matrix(f, data = df)
Z = list(x = lon, y = lat, z = tmax[,,ogr])

rcm_crcm_ecp2_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, -1, 0, 0, 0, 0, 0, 0, 0), V = v_apl)
rcm_crcm_hrm3_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, -1, 0, 0, 0, 0, 0, 0), V = v_apl)
rcm_crcm_mm5i_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, -1, 0, 0, 0, 0, 0), V = v_apl)
rcm_crcm_rcm3_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, 0, -1, 0, 0, 0, 0), V = v_apl)
rcm_crcm_wrfg_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, 0, 0, -1, 0, 0, 0), V = v_apl)
rcm_ecp2_hrm3_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 1, -1, 0, 0, 0, 0, 0, 0), V = v_apl)
rcm_ecp2_mm5i_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 1, 0, -1, 0, 0, 0, 0, 0), V = v_apl)
rcm_ecp2_rcm3_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 1, 0, 0, -1, 0, 0, 0, 0), V = v_apl)
rcm_ecp2_wrfg_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 1, 0, 0, 0, -1, 0, 0, 0), V = v_apl)
rcm_hrm3_mm5i_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 1, -1, 0, 0, 0, 0, 0), V = v_apl)
rcm_hrm3_rcm3_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 1, 0, -1, 0, 0, 0, 0), V = v_apl)
rcm_hrm3_wrfg_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 1, 0, 0, -1, 0, 0, 0), V = v_apl)
rcm_mm5i_rcm3_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, 1, -1, 0, 0, 0, 0), V = v_apl)
rcm_mm5i_wrfg_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, 1, 0, -1, 0, 0, 0), V = v_apl)
rcm_rcm3_wrfg_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, 0, 1, -1, 0, 0, 0), V = v_apl)
gcm_ccsm_cgcm3_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, 0, 0, 0, -1, 0, 0), V = v_apl)
gcm_ccsm_gfdl_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, 0, 0, 0, 0, -1, 0), V = v_apl)
gcm_ccsm_hadcm3_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, 0, 0, 0, 0, 0, -1), V = v_apl)
gcm_cgcm3_gfdl_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, 0, 0, 0, 1, -1, 0), V = v_apl)
gcm_cgcm3_hadcm3_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, 0, 0, 0, 1, 0, -1), V = v_apl)
gcm_gfdl_hadcm3_pl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(0, 0, 0, 0, 0, 0, 0, 0, 1, -1), V = v_apl)

save(rcm_crcm_ecp2_pl, rcm_crcm_hrm3_pl, rcm_crcm_mm5i_pl, rcm_crcm_rcm3_pl, rcm_crcm_wrfg_pl, 
     rcm_ecp2_hrm3_pl, rcm_ecp2_mm5i_pl, rcm_ecp2_rcm3_pl, rcm_ecp2_wrfg_pl, 
     rcm_hrm3_mm5i_pl, rcm_hrm3_rcm3_pl, rcm_hrm3_wrfg_pl,
     rcm_mm5i_rcm3_pl, rcm_mm5i_wrfg_pl,
     rcm_rcm3_wrfg_pl,
     gcm_ccsm_cgcm3_pl, gcm_ccsm_gfdl_pl, gcm_ccsm_hadcm3_pl, 
     gcm_cgcm3_gfdl_pl, gcm_cgcm3_hadcm3_pl,
     gcm_gfdl_hadcm3_pl, 
     file = "cope_apl_bias.rda")
