setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
# load relevant data
load("tmax_summer.rda")
load("tmax_summer_covar.rda")
load("v_asl.rda")
load("fit_details.rda")
# load relevant functions
library(cope)

f = formula(~ rcm + gcm + yr + yr:rcm + yr:gcm)

# only need design matrix for first 356 observations.
# other sequential blocks of 356 will have the exact same design matrix

# corner/treatment constraint
options(contrasts = rep("contr.treatment", 2))
df = data.frame(rcm, gcm, yr)[ogr, ]
X = model.matrix(f, data = df)
Z = list(x = lon, y = lat, z = tmax[,,ogr])

z8 = rep(0, 8)
# rcm12_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, -1, 0, 0, 0, 0, 0, 0, 0, z8))
# rcm13_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, -1, 0, 0, 0, 0, 0, 0, z8))
# rcm14_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, -1, 0, 0, 0, 0, 0, z8))
# rcm15_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, -1, 0, 0, 0, 0, z8))
# rcm16_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, -1, 0, 0, 0, z8))
# rcm23_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 1, -1, 0, 0, 0, 0, 0, 0, z8))
# rcm24_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 1, 0, -1, 0, 0, 0, 0, 0, z8))
# rcm25_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 1, 0, 0, -1, 0, 0, 0, 0, z8))
# rcm26_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 1, 0, 0, 0, -1, 0, 0, 0, z8))
# rcm34_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 1, -1, 0, 0, 0, 0, 0, z8))
# rcm35_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 1, 0, -1, 0, 0, 0, 0, z8))
# rcm36_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 1, 0, 0, -1, 0, 0, 0, z8))
# rcm45_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 1, -1, 0, 0, 0, 0, z8))
# rcm46_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 1, 0, -1, 0, 0, 0, z8))
# rcm56_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 1, -1, 0, 0, 0, z8))
# gcm12_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, -1, 0, 0, z8))
# gcm13_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, 0, -1, 0, z8))
# gcm14_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, 0, 0, -1, z8))
# gcm23_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, 1, -1, 0, z8))
# gcm24_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, 1, 0, -1, z8))
# gcm34_sl = cope_set(temp_cope_array, level = 0, X = X, mask = mask, e = c(0, 0, 0, 0, 0, 0, 0, 0, 1, -1, z8))
# 
# save(rcm12_sl, rcm13_sl, rcm14_sl, rcm15_sl, rcm16_sl, 
#      rcm23_sl, rcm24_sl, rcm25_sl, rcm26_sl, 
#      rcm34_sl, rcm35_sl, rcm36_sl,
#      rcm45_sl, rcm46_sl,
#      rcm56_sl,
#      gcm12_sl, gcm13_sl, gcm14_sl, 
#      gcm23_sl, gcm24_sl,
#      gcm34_sl, 
#      file = "cope_additive_sl_intercept.rda")

z9 = rep(0, 9)
rcm_crcm_ecp2_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, -1, 0, 0, 0, 0, 0, 0, 0), V = v_asl)
rcm_crcm_hrm3_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, -1, 0, 0, 0, 0, 0, 0), V = v_asl)
rcm_crcm_mm5i_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, -1, 0, 0, 0, 0, 0), V = v_asl)
rcm_crcm_rcm3_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, 0, -1, 0, 0, 0, 0), V = v_asl)
rcm_crcm_wrfg_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, 0, 0, -1, 0, 0, 0), V = v_asl)
rcm_ecp2_hrm3_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 1, -1, 0, 0, 0, 0, 0, 0), V = v_asl)
rcm_ecp2_mm5i_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 1, 0, -1, 0, 0, 0, 0, 0), V = v_asl)
rcm_ecp2_rcm3_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 1, 0, 0, -1, 0, 0, 0, 0), V = v_asl)
rcm_ecp2_wrfg_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 1, 0, 0, 0, -1, 0, 0, 0), V = v_asl)
rcm_hrm3_mm5i_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 1, -1, 0, 0, 0, 0, 0), V = v_asl)
rcm_hrm3_rcm3_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 1, 0, -1, 0, 0, 0, 0), V = v_asl)
rcm_hrm3_wrfg_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 1, 0, 0, -1, 0, 0, 0), V = v_asl)
rcm_mm5i_rcm3_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, 1, -1, 0, 0, 0, 0), V = v_asl)
rcm_mm5i_wrfg_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, 1, 0, -1, 0, 0, 0), V = v_asl)
rcm_rcm3_wrfg_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z9, 0, 0, 0, 0, 1, -1, 0, 0, 0), V = v_asl)

z15 = rep(0, 15)
gcm_ccsm_cgcm3_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z15, -1, 0, 0), V = v_asl)
gcm_ccsm_gfdl_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z15, 0, -1, 0), V = v_asl)
gcm_ccsm_hadcm3_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z15, 0, 0, -1), V = v_asl)
gcm_cgcm3_gfdl_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z15, 1, -1, 0), V = v_asl)
gcm_cgcm3_hadcm3_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z15, 1, 0, -1), V = v_asl)
gcm_gfdl_hadcm3_sl = ComputeCope(Z, level = 0, X = X, mask = mask, w = c(z15, 0, 1, -1), V = v_asl)

save(rcm_crcm_ecp2_sl, rcm_crcm_hrm3_sl,
     rcm_crcm_mm5i_sl, rcm_crcm_rcm3_sl,
     rcm_crcm_wrfg_sl, rcm_ecp2_hrm3_sl,
     rcm_ecp2_mm5i_sl, rcm_ecp2_rcm3_sl,
     rcm_ecp2_wrfg_sl,
     rcm_hrm3_mm5i_sl, rcm_hrm3_rcm3_sl,
     rcm_hrm3_wrfg_sl, rcm_mm5i_rcm3_sl,
     rcm_mm5i_wrfg_sl,
     rcm_rcm3_wrfg_sl,
     gcm_ccsm_cgcm3_sl,
     gcm_ccsm_gfdl_sl,
     gcm_ccsm_hadcm3_sl,
     gcm_cgcm3_gfdl_sl,
     gcm_cgcm3_hadcm3_sl,
     gcm_gfdl_hadcm3_sl,
     file = "cope_asl_slope_bias.rda")
