setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
# load relevant data
load("tmax_summer.rda")
load("tmax_summer_covar.rda")
load("v_ipl1.rda")
load("v_ipl2.rda")
load("fit_details.rda")
# load relevant functions
library(cope)

f = formula(~ yr + rcm + gcm + rcm:gcm)

# corner/treatment constraint
options(contrasts = rep("contr.treatment", 2))
df = data.frame(rcm, gcm, yr)[ogr, ]
df1 = df[set1,]
df1$rcm = droplevels(df1$rcm)
df1$gcm = droplevels(df1$gcm)
df2 = df[set2,]
df2$rcm = droplevels(df2$rcm)
df2$gcm = droplevels(df2$gcm)
table(df1$gcm, df1$rcm)
table(df2$gcm, df2$rcm)

X1 = model.matrix(f, data = df1)
X2 = model.matrix(f, data = df2)
otmax = tmax[,,ogr]
Z1 = list(x = lon, y = lat, z = otmax[,,set1])
Z2 = list(x = lon, y = lat, z = otmax[,,set2])

# first experiment
wrfg_pl = ComputeCope(Z = Z1, level = 0, X = X1, mask = mask, w = c(0, 0, 1, 0, 0), V = v_ipl1)
ccsm_pl = ComputeCope(Z = Z1, level = 0, X = X1, mask = mask, w = c(0, 0, 0, 1, 0), V = v_ipl1)
interact_wrfg_ccsm_pl = ComputeCope(Z1, level = 0, X = X1, mask = mask, w = c(0, 0, 0, 0, 1), V = v_ipl1)

# second experiment
hrm3_pl = ComputeCope(Z2, level = 0, X = X2, mask = mask, w = c(0, 0, 1, 0, 0), V = v_ipl2)
hadcm3_pl = ComputeCope(Z2, level = 0, X = X2, mask = mask, w = c(0, 0, 0, 1, 0), V = v_ipl2)
interact_hrm3_hadcm3_pl = ComputeCope(Z2, level = 0, X = X2, mask = mask, w = c(0, 0, 0, 0, 1), V = v_ipl2)

save(interact_wrfg_ccsm_pl, 
     wrfg_pl, 
     ccsm_pl,  
     interact_hrm3_hadcm3_pl, 
     hrm3_pl, 
     hadcm3_pl,
     file = "cope_ipl_bias.rda")