library(SpatialTools)
# library(maps)
library(autoimage)

setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
load("narccap_grid.rda")
load("narccap_mask.rda")

# modify grid coordinates for all narccap locations
lon_all = lon2 - 360
lat_all = lat2
mask_all = mask

# do the same thing for the analyzed portion
load("tmax_summer_covar.rda")
lon_sm = lon - 360
lat_sm = lat
mask_sm = mask

# determine where the points on the two grids match
xy_all = cbind(c(lon_all), c(lat_all))
xy_sm = as.matrix(expand.grid(lon_sm, lat_sm))
xy_mask_sm = c(mask_sm)
xy_sm[which(is.na(xy_mask_sm)), ] = NA
xy_sm = na.omit(xy_sm)
coin = coincident(xy_all, xy_sm)

# format new image for plotting
# that combines all locations
xyimage = rep(1, length(lon_all))
xyimage[coin[,1]] = 2
image_grid = matrix(xyimage, nrow = nrow(lon_all))

# create plot of study area
# save manually as png file
pdf("fig01_study_area.pdf")
autoimage(lon_all, lat_all, image_grid * mask_all, 
          breaks = c(0.5, 1.5, 2.5), col = grey.colors(2), 
          xlab = "", ylab = "", legend = "none", 
          map = "world", proj = "lambert", 
          parameters = c(33, 45),
          xlim = c(-130, -62),
          ylim = c(30, 57),
          axes = FALSE)
legend("bottom", legend = c("NARCCAP domain", "study area"), 
       fill = grey.colors(2), horiz = TRUE, box.col = "white", 
       bg = "white", cex = 1.5)
dev.off()