library(abind)
library(autoimage)
library(RColorBrewer)
setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
source("aux_funcs.R") # to extract rejection locations properly

##################
## Helper functions

## encapsulated data loading
eload <- function(filename){
    attach(filename)
    result <- lapply(ls(pos=2), function(v){get(v, pos=2)})
    names(result) <- ls(pos=2)
    detach()
    return(result)
}

## self-naming list
namelist <- function(...){
    result <- list(...)
    names(result) <- as.list(substitute(list(...)))[-1L]
    return(result)
}

## extraction of COPE rejection locations
## (encapsulated sourcing to avoid clutter)
ne <- new.env()
source("aux_funcs.R", local=ne)
extract <- get("get.rej2", envir=ne)
rm(ne)



##################
## ancillary data

load("tmax_summer_covar.rda")
lon <- lon - 360 
rcm <- sort(unique(rcm))
gcm <- sort(unique(gcm))
dummy <- mask * NA
dimnames(dummy) <- NULL
rm(yr)


##################
## Plotting stuff
mypal = rev(brewer.pal(10, "RdBu"))

##################
## Data cleanup

data <- list()
data$rcm <- list()
data$gcm <- list()

## Load data
indata <- list()
indata$std <- eload("std_asl_slope_bias.rda")
indata$cope <- lapply(eload("cope_asl_slope_bias.rda"), extract)

## Cleanup
for(i in c("cope", "std")){
    for(j in c("gcm","rcm")){
        x <- indata[[i]]

        ## Separate out rcms & gcms
        x <- x[grep(j, names(x))]
        
        ## simplify names
        names(x) <- sub("gcm_","",sub("rcm_","",sub("_sl","",sub("_std","",names(x)))))

        ## fill out lower half of matrix
        n <- names(x)
        nn <- sapply(strsplit(n, "_"), function(x){paste(rev(x),collapse="_")})
        x[nn] <- lapply(x, `-`)

        ## add 0 fields along diagonal
        m <- get(j)
        x[paste0(m,"_",m)] <- rep(list(dummy), length(m))
        
        ## store
        data[[j]][[i]] <- x
    }
}


##################
## calculate rankings

## sum over space
ranks <- rapply(data, sum, how="replace", na.rm=TRUE)

## sum over second model in pairing
for(i in c("cope", "std")){
    for(j in c("gcm","rcm")){
        x <- unlist(ranks[[j]][[i]])
        y <- sapply(get(j), function(m){
            sum(x[grep(paste0(m,"_"),names(x))])
        })
        ranks[[j]][[i]] <- sort(y)
    }
}
       



##################
## Figures

for(i in c("cope", "std")){
    for(j in c("gcm","rcm")){
        
        r <- names(ranks[[j]][[i]])
        rr <- outer(r, r, paste, sep="_")

        dtemp <- abind(data[[j]][[i]][rr], along=3)

        ti <- dimnames(dtemp)[[3]]
        ti <- sub("_", " - ", toupper(ti))
        n <- length(r)
        ti[(0:(n-1))*(n+1)+1] <- ""

        png(paste("fig_asl",i,j,".png",sep='_'),
            height = n, width = n+1, units = "in", res = 300)
        par(mar = c(0.5, 0.5, 1.1, 0.5))
        autoimage(lon, lat, dtemp, size = c(n, n),
                  axes = FALSE, xlab = "", ylab = "",
                  legend = "v",
                  zlim = c(-0.2, 0.2), 
                  col = mypal, cex.main=0.8,
                  map = "world", lrat = 1/2, main = ti,
                  proj = "lambert", parameters = c(33, 45),
                  xlim = c(-118, -75))
        dev.off()
    }
}


## Meh, messy and not real informative.

## #### Merging groups for better comparison
## 
## n <- 4
## m <- n*(n-1)/2
## 
## ## Sorted from biggest to smallest, no dupes
## pairings <- rev(names(sort(sapply(data$gcm$std, sum, na.rm=TRUE))[-(1:(n+m))]))
## 
## t1 <- data$gcm$std[pairings]
## t2 <- data$gcm$cope[pairings]
## 
## etemp <- abind(mapply(list, t1, t2), along=3)
## 
## ti2 <- toupper(sub("_", " - ", pairings))
## ti2 <- c(mapply(c, paste(ti2,"PtI"),paste(ti2,"CoPE")))
## 
## dev.new()
## autoimage(lon, lat, etemp, size = c(3, 4),
##           axes = FALSE, xlab = "", ylab = "",
##           mmar = c(0.5, 0.5, 1.1, 0.5), horizontal = FALSE,
##           zlim = c(-4, 4), col = mypal,
##           map.poly = wor, mrat = 2, main = ti2,
##           xlim = c(-0.23, 0.23), project = TRUE,
##           project.args = list(projection = "lambert",
##               parameters = c(33, 45))
##           )
## 
## 
## n <- 6
## m <- n*(n-1)/2
## 
## ## Sorted from biggest to smallest, no dupes
## pairings <- rev(names(sort(sapply(data$rcm$std, sum, na.rm=TRUE))[-(1:(n+m))]))
## 
## t1 <- data$rcm$std[pairings]
## t2 <- data$rcm$cope[pairings]
## 
## etemp <- abind(mapply(list, t1, t2), along=3)
## 
## ti2 <- toupper(sub("_", " - ", pairings))
## ti2 <- c(mapply(c, paste(ti2,"PtI"),paste(ti2,"CoPE")))
## 
## dev.new()
## autoimage(lon, lat, etemp, size = c(5, 6),
##           axes = FALSE, xlab = "", ylab = "",
##           mmar = c(0.5, 0.5, 1.1, 0.5), horizontal = FALSE,
##           zlim = c(-4, 4), col = mypal,
##           map.poly = wor, mrat = 2, main = ti2,
##           xlim = c(-0.23, 0.23), project = TRUE,
##           project.args = list(projection = "lambert",
##               parameters = c(33, 45))
##           )


### Delta plot

for(j in c("gcm","rcm")){
        
    r <- names(ranks[[j]][["std"]])
    rr <- outer(r, r, paste, sep="_")

    dtemp1  <- abind(data[[j]][["std"]][rr], along=3)
    dtemp2  <- abind(data[[j]][["cope"]][rr], along=3)
    dtemp <- xor(is.na(dtemp1), is.na(dtemp2)) - (is.na(dtemp1) & is.na(dtemp2))


    ti <- dimnames(dtemp)[[3]]
    ti <- sub("_", " - ", toupper(ti))
    n <- length(r)
    ti[(0:(n-1))*(n+1)+1] <- ""
    
    png(paste("figA_asl_delta_", j,".png", sep = ''),
        height = n, width = n + 1, units = "in", res = 300)
    par(mar = c(0.5, 0.5, 1.1, 0.5))
    autoimage(lon, lat, dtemp, size = c(n, n), 
              axes = FALSE, xlab = "", ylab = "",
              legend = "n", zlim = c(-1, 1), 
              col = c("white","gray", "#fc8d59"),
              map = "world", lrat = 1/2, main = ti, 
              cex.main = 0.8,
              proj = "lambert", parameters = c(33, 45),
              xlim = c(-118, -75))
    
    dev.off()
}


