library(abind)
library(autoimage)
library(RColorBrewer)
setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")

##################
## Helper functions

## encapsulated data loading
eload <- function(filename){
    attach(filename)
    result <- lapply(ls(pos = 2), function(v){get(v, pos = 2)})
    names(result) <- ls(pos = 2)
    detach()
    return(result)
}

## self-naming list
namelist <- function(...){
    result <- list(...)
    names(result) <- as.list(substitute(list(...)))[-1L]
    return(result)
}

## extraction of COPE rejection locations
## (encapsulated sourcing to avoid namespace clutter)
ne <- new.env()
source("aux_funcs.R", local = ne)
extract <- get("get.rej2", envir = ne)
rm(ne)



##################
## ancillary data

load("tmax_summer_covar.rda")
lon <- lon - 360 
rcm <- sort(unique(rcm))
gcm <- sort(unique(gcm))
dummy <- mask * NA
dimnames(dummy) <- NULL
rm(yr)


##################
## Plotting stuff
mypal = rev(brewer.pal(10, "RdBu"))


##################
## Data cleanup

data <- list()

## Load data
indata <- list()
indata$std <- eload("std_isl_bias.rda")
indata$cope <- lapply(eload("cope_isl_bias.rda"), extract)


## Cleanup -- for this case, we just want the interact_ terms
for (i in c("cope", "std")) {
    x <- indata[[i]]

    ## pull interaction terms
    x <- x[grep("interact", names(x))]
    ## simplify names
    names(x) <- toupper(sub("_","/",sub("interact_","",sub("_pl","",sub("_std","",names(x))))))
    
    data[[i]] <- x
}


# ##################
# ## calculate rankings
# 
# ## sum over space

ranks <- rapply(data, sum, how = "replace", na.rm = TRUE)
 
sink("ranks.isl.txt")
print(ranks)
sink()


### Delta plot

rr <- c("WRFG/CCSM", "HRM3/HADCM3")

dtemp1  <- abind(data[["std"]][rr], along = 3)
dtemp2  <- abind(data[["cope"]][rr], along = 3)
dtemp <- xor(is.na(dtemp1), is.na(dtemp2)) - (is.na(dtemp1) & is.na(dtemp2))

ti <- dimnames(dtemp)[[3]]

png("figA6_isl_delta.png",
    height = 1, width = 3, units = "in", res = 300)

par(mar = c(0.5, 0.5, 1.1, 0.5))
autoimage(lon, lat, dtemp, size = c(1, 2), 
          axes = FALSE, xlab = "", ylab = "",
          legend = "n", zlim = c(-1, 1), 
          col = c("white","gray", "#fc8d59"),
          map = "world", lrat = 1/2, main = ti, 
          cex.main = 0.4,
          proj = "lambert", parameters = c(33, 45))

dev.off()



