library(maps)
library(abind)
library(autoimage)
library(RColorBrewer)

# load relevant data
setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
load("cope_ipl_bias.rda")
source("aux_funcs.R")

# national boundaries
wor = map("world", plot = FALSE)

# levels(all_data_first_356$rcm)
# "crcm" "ecp2" "hrm3" "mm5i" "rcm3" "wrfg"

# levels (all_data_first_356$aogcm)
# [1] "cgcm3"  "ccsm"   "gfdl"   "hadcm3"

int_rej = abind(get.rej2(interact_wrfg_ccsm_pl),
                  get.rej2(interact_hrm3_hadcm3_pl), along = 3)
range(int_rej, na.rm = TRUE)

mypal = rev(brewer.pal(10, "RdBu"))

png("fig_image_int_cope_ipl_bias.png", height = 2, width = 6, 
    units = "in", res = 300)
par(mar = c(0.5, 0.5, 1.1, 0.5))
autoimage(interact_wrfg_ccsm_pl$x - 360, interact_wrfg_ccsm_pl$y, int_rej, 
          size = c(1, 2), axes = FALSE, xlab = "", ylab = "", 
          legend = "v", zlim = c(-4.5, 4.5), 
          col = mypal, map = "world", lrat = 1/4, 
          main = c("CCSM/WRFG", "HADCM3/HRM3"),
          proj = "lambert", parameters = c(33, 45),
          xlim = c(-118, -75))
dev.off()
