setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
library(abind)
library(autoimage)
library(RColorBrewer)

# load relevant data
source("aux_funcs.R")
load("tmax_summer_covar.rda")
load("std_isl_bias.rda")

# levels(all_data_first_356$rcm)
# "crcm" "ecp2" "hrm3" "mm5i" "rcm3" "wrfg"

# levels (all_data_first_356$aogcm)
# [1] "cgcm3"  "ccsm"   "gfdl"   "hadcm3"

int_rej = abind(interact_wrfg_ccsm_sl_std,
                interact_hrm3_hadcm3_sl_std, along = 3)
range(int_rej, na.rm = TRUE)

mypal = rev(brewer.pal(10, "RdBu"))

png("fig_image_int_std_isl_bias.png", height = 2, width = 6,
    units = "in", res = 300)
par(mar = c(0.5, 0.5, 1.1, 0.5))
autoimage(lon - 360, lat, int_rej, size = c(1, 2), axes = FALSE,
          xlab = "", ylab = "", legend = "v", col = mypal,
          map = "world", lrat = 1/4,
          main = c("ccsm/wrfg", "hadcm3/hrm3"),
          proj = "lambert", parameters = c(33, 45),
          xlim = c(-118, -75))
dev.off()

# slope results
int_rej = abind(interact_wrfg_ccsm_slope_sl_std,
                interact_hrm3_hadcm3_slope_sl_std, along = 3)
range(int_rej, na.rm = TRUE)

mypal = rev(brewer.pal(10, "RdBu"))

png("fig_image_int_std_isl_slope_sl_bias.png", height = 2, width = 6, 
    units = "in", res = 300)
par(mar = c(0.5, 0.5, 1.1, 0.5))
autoimage(lon - 360, lat, int_rej, size = c(1, 2), axes = FALSE, 
          xlab = "", ylab = "", legend = "v", col = mypal, 
          map = "world", lrat = 1/4, 
          main = c("CCSM/WRFG", "HADCM3/HRM3"),
          proj = "lambert", parameters = c(33, 45),
          xlim = c(-118, -75),
          zlim = c(-.1, .1))
dev.off()
