library(abind)
library(autoimage)
library(RColorBrewer)

# load relevant data
setwd("~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis")
load("cope_isl_bias.rda")
source("aux_funcs.R")

# levels(all_data_first_356$rcm)
# "crcm" "ecp2" "hrm3" "mm5i" "rcm3" "wrfg"

# levels (all_data_first_356$aogcm)
# [1] "cgcm3"  "ccsm"   "gfdl"   "hadcm3"

int_rej = abind(get.rej2(interact_wrfg_ccsm_sl),
                get.rej2(interact_hrm3_hadcm3_sl), along = 3)
range(int_rej, na.rm = TRUE)

mypal = rev(brewer.pal(10, "RdBu"))

# only a single significant location
png("image_int_cope_isl_bias.png", height = 2, width = 6, units = "in", res = 150)
par(mar = c(0.5, 0.5, 1.1, 0.5))
autoimage(interact_wrfg_ccsm_sl$x - 360, interact_wrfg_ccsm_sl$y, 
          int_rej, size = c(1, 2), axes = FALSE, xlab = "", ylab = "", 
          legend = "v", 
          col = mypal, map = "world", lrat = 1/2, 
          main = c("CCSM/WRFG", "HADCM3/HRM3"),
          proj = "lambert", parameters = c(33, 45),
          xlim = c(-118, -75))
dev.off()


int_rej = abind(get.rej2(interact_wrfg_ccsm_slope_sl),
                get.rej2(interact_hrm3_hadcm3_slope_sl), along = 3)
range(int_rej, na.rm = TRUE)

mypal = rev(brewer.pal(10, "RdBu"))

# slope results
# only a single significant location
png("image_int_cope_isl_slope_bias.png", height = 2, width = 6, units = "in", res = 150)
par(mar = c(0.5, 0.5, 1.1, 0.5))
autoimage(interact_wrfg_ccsm_sl$x - 360, interact_wrfg_ccsm_sl$y, 
          int_rej, size = c(1, 2), axes = FALSE, xlab = "", ylab = "", 
          legend = "v", 
          col = mypal, map = "world", lrat = 1/2, 
          main = c("CCSM/WRFG", "HADCM3/HRM3"),
          proj = "lambert", parameters = c(33, 45),
          xlim = c(-118, -75))
dev.off()

