wd = "~/Dropbox/UCD_Files/Research/In Progress/narccap/analysis"
setwd(wd)

load("tmax_summer_covar.rda")
load("fit_details.rda")

df = data.frame(gr = paste(gcm, rcm, sep = ":"), gcm, rcm)
df = df[ogr, ]
dfa = unique(df)
df1 = unique(df[set1,])
df2 = unique(df[set2,])

names(p_apl) = dfa$gr
names(p_apl1) = df1$gr
names(p_apl2) = df2$gr
names(p_ipl1) = df1$gr
names(p_ipl2) = df2$gr
names(p_asl) = dfa$gr
names(p_asl1) = df1$gr
names(p_asl2) = df2$gr
names(p_isl1) = df1$gr
names(p_isl2) = df2$gr

lab = function(x) {
  names <- c("ccsm:crcm",   "ccsm:mm5i",   "ccsm:wrfg",   
             "cgcm3:crcm",  "cgcm3:rcm3",  "cgcm3:wrfg",
             "gfdl:ecp2",   "gfdl:hrm3",   "gfdl:rcm3",   
             "hadcm3:ecp2", "hadcm3:hrm3", "hadcm3:mm5i")
  xnames = names(x)
  out = rep(NA, length(names))
  for (i in seq_along(xnames)) {
    w = which(xnames[[i]] == names)
    out[w] = x[i]
  }
  out
}

mydf = data.frame(APL = p_apl,
                  APL1 = lab(p_apl1),
                  APL2 = lab(p_apl2),
                  IPL1 = lab(p_ipl1),
                  IPL2 = lab(p_ipl2),
                  ASL = p_asl,
                  ASL1 = lab(p_asl1),
                  ASL2 = lab(p_asl2),
                  ISL1 = lab(p_isl1),
                  ISL2 = lab(p_isl2)
                  )

library(xtable)
xtable(mydf, display = rep("d", 11))
