      parameter(ite=1200,irep=1)
      COMMON /IFMGKS/LUNGKS,ITEST     ! IFM-KOMMUNIKATION
      CHARACTER ZAHL*5,UBER*90,SYM*1,FMT*4,name*25
      REAL DIF(ite),wer(1050,ite)
      character staname(1050)*42,para(8)*50
      integer knbr(1050,16)
      real ss(6)
c
      data para/'Daily Temperature','Daily Maximum Temperature',
     *          'Temperature at strong diurnal cycle',
     *          'Wet days below 1 mm','Wet days',
     *          'Wet days above 1 mm','Monthly Mean Precipitation',
     *          'Diurnal Temperature Range'/
c
      ITEST=1         ! SET IFM TESTPHASE
      LUNGKS=99       ! ERRORAUSGABE AUF UNIT 99
      CALL GOPKS(LUNGKS,0)
C
C     OPEN AND ACTITVATE METAFILE OUTPUT
C
      IWTM=1  ! SET WORKSTATION TYPE (IMPLEMENTATION DEPENDENT)
      IWK2=2
      LUNMET=88
      CALL GOPWK(IWK2,LUNMET,IWTM)
      CALL GACWK(IWK2)
      CALL GSELNT(0)                                ! norm. Koordinaten
C
      xxa=0.2
      xxe=0.8
      yya=0.2
      yye=0.8
c
      ipar=1
      inx=1
c
      xa=0.
      xe=1050.
c
      ya=-3.0
      ye= 3.0
c
      itr=1
      call set (xxa,xxe,yya,yye,xa,xe,ya,ye,itr)      ! Benutzerkoordinaten
C
      call labmod('(f4.0)','(f4.0)',3,3,2,2,30,30,0)
C
      IX=1
      IIX=20
      IY=6
      IIY=5
c
      CALL PERIM(IX,IIX,IY,IIY)
      CALL GSELNT(0)                                ! norm. Koordinaten
c
      CALL WTSTR((XXA+XXE)/2.,YYA-.1,'Station pair number',2,0,0)
      CALL WTSTR(XXA-.1,(YYA+YYE)/2.,'Trend difference (K/cty)',2,90,0)
c
      call set (xxa,xxe,yya,yye,xa,xe,ya,ye,itr)      ! Benutzerkoordinaten
c
      ja1=601
      ja2=ite
c
c      idat=2
      ist=1050
c
      call limon3(ipar,inx,staname,wer,knbr)
c
      is1=1
      is2=ist
c
      su2=0.
      sum=0.
      sev=0.
      zum=0.
c
      do is=is1,is2
        ista1=is
        ista2=knbr(ista1,1)
c
        do ii=1,6
          ss(ii)=0.
        enddo
c
        do j=ja1,ja2
          xx=float(j-1)/12.
          yy=wer(is,j)
          if(yy.gt.-9990.)then
            ss(1)=ss(1)+xx*xx
            ss(2)=ss(2)+xx*yy
            ss(3)=ss(3)+yy*yy
            ss(4)=ss(4)+xx
            ss(5)=ss(5)+yy
            ss(6)=ss(6)+1.
          endif            
        enddo
c
        if(ss(6).gt.1.5)then
c
          call trerr(ss,trend,errvar)
          error=sqrt(errvar)
c
          xx=float(is)
          yy=trend
          call line(xx-5.,yy,xx+5.,yy)
          call line(xx,yy-error,xx,yy+error)
          su2=su2+trend*trend
          sum=sum+trend
          zum=zum+1.
          sev=sev+errvar
        endif        
c
      enddo
c
      if(zum.gt.1.5)then
        sev=sev/zum
        xm=sum/zum
        six=(su2-xm*sum)/(zum-1.)
        stddev=sqrt(six)
        call line(xa,xm,xe,xm)
        call line(xa,xm+stddev,xe,xm+stddev)
        call line(xa,xm-stddev,xe,xm-stddev)
      endif
c
      write(uber,'(a,f6.3,a)')'stddev =',stddev,' K/cty'
      xx=xa+0.50*(xe-xa)
      yy=ya+0.93*(ye-ya)
      call wtstr(xx,yy,UBER,2,0,-1)
c
      CALL GSELNT(0)                                ! norm. Koordinaten
c
      dx=0.
      fak=0.1
c
      do i=1,1050,1049
        write(zahl,'(i4)')i
        xx=xxa + (i-xa+dx)*(xxe-xxa)/(xe-xa)
        yy=yya - 0.04
        call wtstr(xx,yy,zahl,2,0,0)
      enddo
c
      do j=-30,30,10
        write(zahl,'(f4.1)')fak*j
        xx=xxa-0.01
        yy=yya + (fak*j-ya)*(yye-yya)/(ye-ya)
        call wtstr(xx,yy,zahl,2,0,1)
      enddo
C
      CALL GDAWK(2)
      CALL GCLWK(2)
      CALL GCLKS
      END
c
c
c
      subroutine trerr(ss,stg,errvar)
c
      real ss(6)
      character theobs(4)*30
c
      sxx=ss(1)
      sxy=ss(2)
      syy=ss(3)
      sx= ss(4)
      sy= ss(5)
      s1= ss(6)
c
	if(s1.gt.1.5)then
	  xm=sx/s1
	  six=sqrt((sxx-xm*sx)/(s1-1.))
	  ym=sy/s1
	  siy=sqrt((syy-ym*sy)/(s1-1.))
	  sixy=(sxy-xm*sy)/(s1-1.)
	  r=sixy/six/siy
	  stgnorm=sqrt(r*r*(s1-2.)/(1.-r*r))
	  stg=sixy/six/six
	  con=ym-stg*xm
	  x1=50.
	  y1=stg*x1+con
	  x2=100.
	  y2=stg*x2+con
c
	  write(theobs(3),'(a7,f9.4,a9)')'trend =',100.*stg,' mm/d/cty'
c
	  stdstg=siy/six*sqrt((1-r*r)/(s1-1.))
	  write(theobs(4),'(a7,f10.4,a9)')'error =',100.*stdstg,
     *                                   ' mm/d/cty'
c
	endif
c
        stg=stg*100.
        errvar=(stdstg*100.)**2
      return
      end
c
c
c
      subroutine runmean(ite,ja1,ja2,sud,zud)
c
      real sud(ite),zud(ite)
c
      md=12
      do j=ja1+md,ja2-md
        sum=0.
        zum=0.
        xx=float(j)/12.+1900.
        do jj=j-md+1,j+md
          if(zud(jj).gt.0.5)then
            ym=sud(jj)/zud(jj)
            sum=sum+ym
            zum=zum+1.
          endif
        enddo
        if(zum.gt.0.5)then
          sum=sum/zum
          call wtstr(xx,sum,'+',0,0,0)
        endif
      enddo
c
      return
      end
c
c
c
      subroutine limon3(ipar,inx,staname,wer,knbr)
c
      parameter(ist=1050)
      real xla(ist),phi(ist),wert(ist,0:100,12)
      real xmit(ist,12),xsig(ist,12),c(2)
      real wer(ist,1200)
      integer knbr(ist,16)
      character staname(ist)*42
c
      call lies3(ipar,ist,inx,xla,phi,wert,xmit,xsig,staname)
      call corr_16(ist,xla,phi,wert,knbr)
c
      do i=1,ist
      do j=1,100
      do m=1,12
        mm=(j-1)*12 + m
        wer(i,mm)=-9999.
        x=wert(i,j,m)
        y=wert(knbr(i,1),j,m)
c
        if((x.gt.-9990.).and.(y.gt.-9990.))then
          wer(i,mm)=x-y
        endif
c
      enddo
      enddo
      enddo
c
      return
      end
c
c
c
      subroutine lies3(ipar,ist,inx,xla,phi,wert,xmit,xsig,staname)
      real xla(ist),phi(ist),wert(ist,0:100,12)
      real xmit(ist,12),xsig(ist,12)
      character staname(ist)*42,par(8)*3
c
      data par/'t2m','tmx','vi3','ru1','w00','w10','pcp','tdc'/
c  
      open(unit=30,file='likladay.dat',status='old')
c
      do i=1,ist
        read(30,'(i5,a42,2f8.4)')k,staname(k),xla(k),phi(k)
      enddo
      close(30)
c
      do k=1,ist
      do j=0,100
      do m=1,12
        wert(k,j,m)=-9999.
      enddo
      enddo
      enddo
c
      su2=0.
      sum=0.
      zum=0.
c
      open(unit=31,file='likladam.'//par(ipar),status='old')
   10 read(31,'(i4,3i3,2f8.4,2f5.1)',end=20)k,j,m,ianz,xm,six,xmx,xmn
c
        if(inx.eq.2)xm=six
        if(inx.eq.3)xm=xmx
        if(inx.eq.4)xm=xmn
c
        if(ianz.gt.20)then
          wert(k,j,m)=xm
          su2=su2+xm*xm
          sum=sum+xm
          zum=zum+1.
        endif
      goto 10
   20 continue
      close(31)
c
      if(zum.gt.1.5)then
        xm=sum/zum
        six=sqrt((su2-xm*sum)/(zum-1.))
      endif
c
      do k=1,ist
      do m=1,12
        sxx=0.
        sx=0.
        s1=0.
        do j=61,90
          if(wert(k,j,m).gt.-9990.)then
            x=wert(k,j,m)
            sxx=sxx+x*x
            sx=sx+x
            s1=s1+1.
          endif
        enddo
        if(s1.gt.29.5)then
          xm=sx/s1
          six=sqrt((sxx-sx*xm)/(s1-1.))
          xmit(k,m)=xm
          xsig(k,m)=six
        else
          xmit(k,m)=-9999.
          xsig(k,m)=-9999.
        endif
        do j=0,100
          if((wert(k,j,m).gt.-9990.).and.(xsig(k,m).gt.0.))then
            wert(k,j,m)=wert(k,j,m)-xmit(k,m)
          else
            wert(k,j,m)=-9999.
          endif
        enddo
      enddo
      enddo
c
      su2=0.
      sum=0.
      zum=0.
c
      do k=1,ist
      do j=0,100
      do m=1,12
        if(wert(k,j,m).gt.-9990.)then
          x=wert(k,j,m)
          su2=su2+x*x
          sum=sum+x
          zum=zum+1.
        endif
      enddo
      enddo
      enddo
c
      if(zum.gt.1.5)then
        xm=sum/zum
        six=sqrt((su2-xm*sum)/(zum-1.))
      endif
c
      zall=0.
      do k=1,ist
        zum=0.
        do m=1,12
        do j=51,100
          if(wert(k,j,m).gt.-9990.)zum=zum+1.
        enddo
        enddo
        if(zum.gt.0.5)then
          zall=zall+1.
        endif
      enddo
c
      return
      end
c
c
c
      subroutine corr_16(ist,xla,phi,wert,knbr)
c
      parameter(ianz=16)
      real xla(ist),phi(ist),wert(ist,0:100,12)
      integer knbr(ist,ianz)
      real crit(ianz),corr(ianz)
c
      pi=acos(-1.)
      grad=1000./9.
c
      do k1=1,ist
        do i=1,ianz
          knbr(k1,i)=0
          crit(i)=9999.
          corr(i)=9999.
        enddo
c          
        do k2=1,ist
          sxx=0.
          sxy=0.
          syy=0.
          sx=0.
          sy=0.
          s1=0.
          sp=0.
          rr=-9999.
c
          phim=0.5*(phi(k1)+phi(k2))
          cph=cos(pi*phim/180.)
          dx=(xla(k1)-xla(k2))*grad*cph
          dy=(phi(k1)-phi(k2))*grad
          d=sqrt(dx*dx + dy*dy)
c
          if((d.gt.10.).and.(d.lt.100.))then
            do j=51,100
            do m=1,12
              sp=sp+1.
              x=wert(k1,j,m)
              y=wert(k2,j,m)
              if((x.gt.-9990.).and.(y.gt.-9990.))then
                sxx=sxx+x*x
                sxy=sxy+x*y
                syy=syy+y*y
                sx=sx+x
                sy=sy+y
                s1=s1+1.
              endif
            enddo
            enddo
c
            if(s1.gt.1.5)then
              xm=sx/s1
              six=sqrt((sxx-xm*sx)/(s1-1.))
              ym=sy/s1
              siy=sqrt((syy-ym*sy)/(s1-1.))
              sixy=(sxy-xm*sy)/(s1-1.)
              rr=sixy/six/siy
              cri=sp/s1 * (1.-rr)
              iplz=ianz+1
              do i=ianz,1,-1
                if(cri.lt.crit(i))iplz=i
              enddo
              do i=ianz,iplz+1,-1
                crit(i)=crit(i-1)
                corr(i)=corr(i-1)
                knbr(k1,i)=knbr(k1,i-1)
              enddo
              if(iplz.le.ianz)then
                crit(iplz)=cri
                corr(iplz)=rr
                knbr(k1,iplz)=k2
              endif
            endif                        
          endif
        enddo
      enddo
c
      return
      end
c
c
c
      SUBROUTINE LENGTH(N,C,L)
C
      CHARACTER C*90,CM*1
C
      DO 10 I=1,N
        READ(C(I:I),'(A1)')CM
        IF(CM.NE.' ')L=I
   10 CONTINUE
      RETURN
      END
